﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint.WebControls;
using Microsoft.SharePoint;

namespace SharePointCustomActions
{
   public class ListSettingsMenu : System.Web.UI.WebControls.WebControl
   {
      
      protected override void CreateChildControls()
      {
         SubMenuTemplate subMenu = new SubMenuTemplate();
         subMenu.Sequence = 1;
         subMenu.Text = "Alle Listen";
         subMenu.Description = "Direkter Zugriff auf alle Listen.";
         subMenu.ImageUrl = "/_layouts/images/allcontent32.png";

         foreach (SPList list in SPContext.Current.Web.Lists)
         {
            if (!list.Hidden)
            {
               MenuItemTemplate itemTemplate = new MenuItemTemplate();
               itemTemplate.Text = list.Title;
               itemTemplate.Description = list.Description;
               itemTemplate.ImageUrl = list.ImageUrl;
               itemTemplate.ClientOnClickNavigateUrl = 
                  list.DefaultViewUrl;

               subMenu.Controls.Add(itemTemplate);
            }
         }

         this.Controls.Add(subMenu);
      }

      protected override void OnPreRender(EventArgs e)
      {          
         base.OnPreRender(e);
      }
   }
}